 ; Ŀ
 ;   Dm - remove text masks, kill the group which contained them.          
 ;   Copyright 1999, 2006 by Rocket Software Ltd.                          
 ;   There are apparently different wipeout types, the type is stored      
 ;   in the exdata attached to the text entity.  It may be necessary to    
 ;   destroy different types of mask entities based on this.               
 ;                                                                         
 ; 

 ; Ŀ
 ;   Exkill - remove the extended data from an entity.                     
 ;   Amazingly, this works: remove everything from the xdata for the       
 ;   app in question except the app name, entmod it back in, acad          
 ;   ditches the entire app xdata set from that entity.                    
 ;   Completely removing the xdata for that app doesn't work - acad        
 ;   assumes that it isn't touching the xdata for that app at all.         
 ;                                                                         
 ;   Arguments: Enam - the entity name.                                    
 ;              appi - the application to remove the data for.             
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN EXKILL (enam appi / entt exdat sub nuex)
  (setq entt (entget enam (list "*")))
  (if (setq exdat (assoc -3 entt))
      (progn
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (if (and (= (type sub) 'LIST)
                           (= (car sub) appi))
                      (setq nuex (append nuex (list (list (car sub)))))
                      (setq nuex (append nuex (list sub)))))
           (entmod (append (entget enam) (list nuex)))))
 (princ))
 ; Ŀ
 ;   Exkill end.                                                           
 ; 

 ; Ŀ
 ;   Grrr - get group data for an entity.                                  
 ;   Argument: Enam - the entity name.                                     
 ;   Returns a list of lists: ((group_name member_ename ...) ...)          
 ;   or nil if the entity wasn't a member of any groups.                   
 ;                                                                         
 ;   Note that a group can't contain other groups as such - including one  
 ;   group in another adds its members.                                    
 ; 
 (DEFUN GRRR (enam / num sub entt grenam subent newlst subnum grlist master
                                          mast2 grdict grnams grenam grpnam)
  (setq entt (entget enam))
 ; Ŀ
 ;   There will be one 330 group in the entity data for each group to      
 ;   which the object belongs.  Note that an entity can belong to          
 ;   multiple groups.  So get a list of their enames.                      
 ;   Also: check to see if this really is a group and not some other type  
 ;   of reactor.  (The 0 group in the entity data for the 330 group in     
 ;   the original entity is (0 . "GROUP"))                                 
 ; 
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (and (= (car sub) 330)
                  (= (cdr (assoc 0 (entget (cdr sub)))) "GROUP"))
             (setq grlist (cons (cdr sub) grlist)))
         (setq num (1+ num)))
 ; Ŀ
 ;   If any of the 330 enames were Groups, add the enames of the entities  
 ;   contained in each group to the appropriate sublist.                   
 ; 
  (if grlist
      (progn
           (setq num 0)
           (while (setq grenam (nth num grlist))
                  (setq subent (entget grenam))
                  (setq newlst (list grenam))
                  (setq subnum 0)
                  (while (setq sub (nth subnum subent))
                         (if (= (car sub) 340)
                             (setq newlst (append newlst (list (cdr sub)))))
                         (setq subnum (1+ subnum)))
                  (setq master (cons newlst master))
                  (setq num (1+ num)))
 ; Ŀ
 ;   Add the group name of each group to the start of its sublist.         
 ;   First get a copy of the master group list.                            
 ; 
           (setq grdict (dictsearch (namedobjdict) "acad_group"))
           (setq grnams (reverse grdict))
 ; Ŀ
 ;   Get the name for each group from the list.                            
 ; 
           (setq num 0)
           (while (setq sub (nth num master))
                  (setq grenam (car sub))
                  (setq grpnam (cadr (member (cons 350 grenam) grnams)))
                  (setq sub (cons (cdr grpnam) sub))
                  (setq mast2 (cons sub mast2))
                  (setq num (1+ num)))))
 mast2)
 ; Ŀ
 ;   Grrr end.                                                             
 ; 

 ; Ŀ
 ;   Dm.                                                                   
 ; 
 (DEFUN C:DM (/ *error* snapp ss num enam entt grdat sub gstr grpnam grkill
                                                                     whipp)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk /)
  (if shk (write-line shk))
  (setvar "snapmode" snapp)
 (princ))
 ; Ŀ
 ;   Turn snap off.                                                        
 ; 
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Get a selection set of text to de-mask.  Should this be done for      
 ;   other entity types?                                                   
 ; 
  (write-line "Select text to de-mask:")
  (setq ss (ssget (list (cons 0 "text"))))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam (list "*")))
 ; Ŀ
 ;   If the entity belongs to any groups, get their data.                  
 ; 
         (if (assoc 330 entt)
             (progn
                  (setq grdat (grrr enam))
 ; Ŀ
 ;   For each group sublist...                                             
 ; 
                  (while (setq sub (car grdat))
                         (setq grdat (cdr grdat))
                         (setq grpnam (car sub))
                         (setq sub (cddr sub))  ; remove group name and ename
                         (setq grkill ())
                         (while (setq whipp (car sub))
                                (setq sub (cdr sub))
 ; Ŀ
 ;   If the entity was a wipeout, erase it and set the kill group flag.    
 ; 
                                (if (= (cdr (assoc 0 (entget whipp)))
                                       "WIPEOUT")
                                    (progn
                                         (setq grkill t)
                                         (entdel whipp))))
 ; Ŀ
 ;   If the kill group flag is set then explode the group and remove the   
 ;   exdata from the text entity.                                          
 ; 
                         (if grkill
                             (progn
                                  (command ".-group" "explode" grpnam)
                                  (exkill enam "ACET-TEXTMASK")))))))
  (*error* ())
 (princ))